/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightSurroundReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightSurroundReliefSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_HEIGHT_MIN = -12000.0;
    public static final Double DEFAULT_HEIGHT_MAX = 9000.0;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    public static final Integer DEFAULT_FLATTEN_NOISE = 0;
    public static final Integer DEFAULT_FLATTEN_POINT_NOISE = 0;
    public static final Integer DEFAULT_EXPENSIVE_BLUR = 0;
    public static final String DEFAULT_SKIP_HEIGHTS = "";
    public static final Double DEFAULT_SUNRAY_DIRECTION_CLOCKWISE = 90.0;
    public static final Double DEFAULT_SHADOW_CIRCUMFENCE = 120.0;
    public static final Double DEFAULT_SHADOW_CIRCUMFENCE_WEIGHT = 0.5;
    public static final Double DEFAULT_SHADOW_INTENSITY = 1.0;
    private OsmHeightSurroundReliefSymbolizer osmHeightSurroundReliefSymbolizer;
    private Double cachedHeightMin = null;
    private Double cachedHeightMax = null;
    private Color cachedColor = null;
    private Boolean cachedRenderMockTiles = null;
    private Integer cachedFlattenNoise = null;
    private Integer cachedFlattenPointNoise = null;
    private Integer cachedExpensiveBlur = null;
    private String cachedSkipHeights = null;
    private Double cachedSunrayDirectionClockwise = null;
    private Double cachedShadowCircumfence = null;
    private Double cachedShadowCircumfenceWeight = null;
    private Double cachedShadowIntensity = null;
    private Optional<Double> cachedForcedAggregationRadius = null;

    public OsmHeightSurroundReliefSymbolizerAccessor(OsmHeightSurroundReliefSymbolizer osmHeightSurroundReliefSymbolizer) {
        this.osmHeightSurroundReliefSymbolizer = osmHeightSurroundReliefSymbolizer;
    }

    public OsmHeightSurroundReliefSymbolizer getOsmHeightSurroundReliefSymbolizer() {
        return this.osmHeightSurroundReliefSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightSurroundReliefSymbolizer.getIdentifier());
    }

    public Double getSunrayDirectionClockwise() {
        if (this.cachedSunrayDirectionClockwise == null) {
            this.cachedSunrayDirectionClockwise = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getSunrayDirectionClockwise()), DEFAULT_SUNRAY_DIRECTION_CLOCKWISE);
        }
        return this.cachedSunrayDirectionClockwise;
    }

    public Double getShadowCircumfence() {
        if (this.cachedShadowCircumfence == null) {
            this.cachedShadowCircumfence = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getShadowCircumfence()), DEFAULT_SHADOW_CIRCUMFENCE);
        }
        return this.cachedShadowCircumfence;
    }

    public Double getShadowCircumfenceWeight() {
        if (this.cachedShadowCircumfenceWeight == null) {
            this.cachedShadowCircumfenceWeight = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getShadowCircumfenceWeight()), DEFAULT_SHADOW_CIRCUMFENCE_WEIGHT);
        }
        return this.cachedShadowCircumfenceWeight;
    }

    public Double getShadowIntensity() {
        if (this.cachedShadowIntensity == null) {
            this.cachedShadowIntensity = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getShadowIntensity()), DEFAULT_SHADOW_INTENSITY);
        }
        return this.cachedShadowIntensity;
    }

    public Optional<Double> getForcedAggregationRadius() {
        if (this.cachedForcedAggregationRadius == null) {
            this.cachedForcedAggregationRadius = this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getForcedAggregationRadius());
        }
        return this.cachedForcedAggregationRadius;
    }

    public String getSkipHeights() {
        if (this.cachedSkipHeights == null) {
            this.cachedSkipHeights = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmHeightSurroundReliefSymbolizer.getSkipHeights()), DEFAULT_SKIP_HEIGHTS);
        }
        return this.cachedSkipHeights;
    }

    public Double getHeightMin() {
        if (this.cachedHeightMin == null) {
            this.cachedHeightMin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getHeightMin()), DEFAULT_HEIGHT_MIN);
        }
        return this.cachedHeightMin;
    }

    public Double getHeightMax() {
        if (this.cachedHeightMax == null) {
            this.cachedHeightMax = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightSurroundReliefSymbolizer.getHeightMax()), DEFAULT_HEIGHT_MAX);
        }
        return this.cachedHeightMax;
    }

    public Integer getFlattenNoise() {
        if (this.cachedFlattenNoise == null) {
            this.cachedFlattenNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightSurroundReliefSymbolizer.getFlattenNoise()), DEFAULT_FLATTEN_NOISE);
        }
        return this.cachedFlattenNoise;
    }

    public Integer getFlattenPointNoise() {
        if (this.cachedFlattenPointNoise == null) {
            this.cachedFlattenPointNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightSurroundReliefSymbolizer.getFlattenPointNoise()), DEFAULT_FLATTEN_POINT_NOISE);
        }
        return this.cachedFlattenPointNoise;
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightSurroundReliefSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightSurroundReliefSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public Integer getExpensiveBlur() {
        if (this.cachedExpensiveBlur == null) {
            this.cachedExpensiveBlur = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightSurroundReliefSymbolizer.getExpensiveBlur()), DEFAULT_EXPENSIVE_BLUR);
        }
        return this.cachedExpensiveBlur;
    }

    public String toString() {
        return "OsmHeightSurroundReliefSymbolizerAccessor[" + this.osmHeightSurroundReliefSymbolizer + "]";
    }
}

