/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightReliefSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightReliefSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_HEIGHT_MIN = -12000.0;
    public static final Double DEFAULT_HEIGHT_MAX = 9000.0;
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final String DEFAULT_SHADOW_SUN_PLACEMENT = "W";
    public static final Float DEFAULT_SHADOW_SUN_HEIGHT = Float.valueOf(35.0f);
    public static final Float DEFAULT_SHADOW_IMPACT = Float.valueOf(100.0f);
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    public static final Integer DEFAULT_FLATTEN_NOISE = 0;
    public static final Integer DEFAULT_FLATTEN_POINT_NOISE = 0;
    public static final Integer DEFAULT_EXPENSIVE_BLUR = 0;
    public static final String DEFAULT_SKIP_HEIGHTS = "";
    private OsmHeightReliefSymbolizer osmHeightReliefSymbolizer;
    private Double cachedHeightMin = null;
    private Double cachedHeightMax = null;
    private Color cachedColor = null;
    private String cachedShadowSunPlacement = null;
    private Float cachedShadowSunHeight = null;
    private Float cachedShadowImpact = null;
    private Boolean cachedRenderMockTiles = null;
    private Integer cachedFlattenNoise = null;
    private Integer cachedFlattenPointNoise = null;
    private Integer cachedExpensiveBlur = null;
    private String cachedSkipHeights = null;

    public OsmHeightReliefSymbolizerAccessor(OsmHeightReliefSymbolizer osmHeightReliefSymbolizer) {
        this.osmHeightReliefSymbolizer = osmHeightReliefSymbolizer;
    }

    public OsmHeightReliefSymbolizer getOsmHeightReliefSymbolizer() {
        return this.osmHeightReliefSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightReliefSymbolizer.getIdentifier());
    }

    public Float getShadowSunHeight() {
        if (this.cachedShadowSunHeight == null) {
            this.cachedShadowSunHeight = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightReliefSymbolizer.getShadowSunHeight()), DEFAULT_SHADOW_SUN_HEIGHT.floatValue());
        }
        return this.cachedShadowSunHeight;
    }

    public Float getShadowImpact() {
        if (this.cachedShadowImpact == null) {
            this.cachedShadowImpact = this.getFromOptionalOrElse(this.safeParseFloat(this.osmHeightReliefSymbolizer.getShadowImpact()), DEFAULT_SHADOW_IMPACT.floatValue());
        }
        return this.cachedShadowImpact;
    }

    public String getShadowSunPlacement() {
        if (this.cachedShadowSunPlacement == null) {
            this.cachedShadowSunPlacement = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmHeightReliefSymbolizer.getShadowSunPlacement()), DEFAULT_SHADOW_SUN_PLACEMENT);
        }
        return this.cachedShadowSunPlacement;
    }

    public String getSkipHeights() {
        if (this.cachedSkipHeights == null) {
            this.cachedSkipHeights = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmHeightReliefSymbolizer.getSkipHeights()), DEFAULT_SKIP_HEIGHTS);
        }
        return this.cachedSkipHeights;
    }

    public Double getHeightMin() {
        if (this.cachedHeightMin == null) {
            this.cachedHeightMin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightReliefSymbolizer.getHeightMin()), DEFAULT_HEIGHT_MIN);
        }
        return this.cachedHeightMin;
    }

    public Double getHeightMax() {
        if (this.cachedHeightMax == null) {
            this.cachedHeightMax = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightReliefSymbolizer.getHeightMax()), DEFAULT_HEIGHT_MAX);
        }
        return this.cachedHeightMax;
    }

    public Integer getFlattenNoise() {
        if (this.cachedFlattenNoise == null) {
            this.cachedFlattenNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightReliefSymbolizer.getFlattenNoise()), DEFAULT_FLATTEN_NOISE);
        }
        return this.cachedFlattenNoise;
    }

    public Integer getFlattenPointNoise() {
        if (this.cachedFlattenPointNoise == null) {
            this.cachedFlattenPointNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightReliefSymbolizer.getFlattenPointNoise()), DEFAULT_FLATTEN_POINT_NOISE);
        }
        return this.cachedFlattenPointNoise;
    }

    public Color getColor() {
        if (this.cachedColor == null) {
            Optional<String> optionalColor = this.safeGetNonEmptyString(this.osmHeightReliefSymbolizer.getColor());
            this.cachedColor = optionalColor.isPresent() ? ColorUtil.getColorFromString(optionalColor.get()) : DEFAULT_COLOR;
        }
        return this.cachedColor;
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightReliefSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public Integer getExpensiveBlur() {
        if (this.cachedExpensiveBlur == null) {
            this.cachedExpensiveBlur = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightReliefSymbolizer.getExpensiveBlur()), DEFAULT_EXPENSIVE_BLUR);
        }
        return this.cachedExpensiveBlur;
    }

    public String toString() {
        return "OsmHeightReliefSymbolizerAccessor[" + this.osmHeightReliefSymbolizer + "]";
    }
}

