/*
 * Decompiled with CFR 0.152.
 */
package de.wideportal.maprender.config.xml.osm.accessor;

import de.wideportal.maprender.config.xml.osm.OsmHeightColorSymbolizer;
import de.wideportal.maprender.config.xml.osm.accessor.BaseAccessor;
import de.wideportal.maprender.util.color.ColorUtil;
import java.awt.Color;
import java.util.Optional;

public class OsmHeightColorSymbolizerAccessor
extends BaseAccessor {
    public static final Double DEFAULT_HEIGHT_MIN = -12000.0;
    public static final Double DEFAULT_HEIGHT_MAX = 9000.0;
    public static final Color DEFAULT_COLOR_MIN = new Color(0, 0, 0, 0);
    public static final Color DEFAULT_COLOR_MAX = new Color(0, 0, 0, 1);
    public static final Boolean DEFAULT_RENDER_MOCK_TILES = true;
    public static final Integer DEFAULT_FLATTEN_NOISE = 0;
    public static final Integer DEFAULT_FLATTEN_POINT_NOISE = 0;
    public static final Integer DEFAULT_EXPENSIVE_BLUR = 0;
    public static final String DEFAULT_SKIP_HEIGHTS = "";
    private OsmHeightColorSymbolizer osmHeightColorSymbolizer;
    private Double cachedHeightMin = null;
    private Double cachedHeightMax = null;
    private Color cachedColorMin = null;
    private Color cachedColorMax = null;
    private Boolean cachedRenderMockTiles = null;
    private Integer cachedFlattenNoise = null;
    private Integer cachedFlattenPointNoise = null;
    private Integer cachedExpensiveBlur = null;
    private String cachedSkipHeights = null;

    public OsmHeightColorSymbolizerAccessor(OsmHeightColorSymbolizer osmHeightColorSymbolizer) {
        this.osmHeightColorSymbolizer = osmHeightColorSymbolizer;
    }

    public OsmHeightColorSymbolizer getOsmHeightColorSymbolizer() {
        return this.osmHeightColorSymbolizer;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.osmHeightColorSymbolizer.getIdentifier());
    }

    public String getSkipHeights() {
        if (this.cachedSkipHeights == null) {
            this.cachedSkipHeights = this.getFromOptionalOrElse(this.safeGetNonEmptyString(this.osmHeightColorSymbolizer.getSkipHeights()), DEFAULT_SKIP_HEIGHTS);
        }
        return this.cachedSkipHeights;
    }

    public Double getHeightMin() {
        if (this.cachedHeightMin == null) {
            this.cachedHeightMin = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightColorSymbolizer.getHeightMin()), DEFAULT_HEIGHT_MIN);
        }
        return this.cachedHeightMin;
    }

    public Double getHeightMax() {
        if (this.cachedHeightMax == null) {
            this.cachedHeightMax = this.getFromOptionalOrElse(this.safeParseDouble(this.osmHeightColorSymbolizer.getHeightMax()), DEFAULT_HEIGHT_MAX);
        }
        return this.cachedHeightMax;
    }

    public Integer getFlattenNoise() {
        if (this.cachedFlattenNoise == null) {
            this.cachedFlattenNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightColorSymbolizer.getFlattenNoise()), DEFAULT_FLATTEN_NOISE);
        }
        return this.cachedFlattenNoise;
    }

    public Integer getFlattenPointNoise() {
        if (this.cachedFlattenPointNoise == null) {
            this.cachedFlattenPointNoise = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightColorSymbolizer.getFlattenPointNoise()), DEFAULT_FLATTEN_POINT_NOISE);
        }
        return this.cachedFlattenPointNoise;
    }

    public Color getColorMin() {
        if (this.cachedColorMin == null) {
            Optional<String> optionalColorMin = this.safeGetNonEmptyString(this.osmHeightColorSymbolizer.getColorMin());
            this.cachedColorMin = optionalColorMin.isPresent() ? ColorUtil.getColorFromString(optionalColorMin.get()) : DEFAULT_COLOR_MIN;
        }
        return this.cachedColorMin;
    }

    public Color getColorMax() {
        if (this.cachedColorMax == null) {
            Optional<String> optionalColorMax = this.safeGetNonEmptyString(this.osmHeightColorSymbolizer.getColorMax());
            this.cachedColorMax = optionalColorMax.isPresent() ? ColorUtil.getColorFromString(optionalColorMax.get()) : DEFAULT_COLOR_MAX;
        }
        return this.cachedColorMax;
    }

    public Optional<String> getColorRanges() {
        return Optional.ofNullable(this.osmHeightColorSymbolizer.getColorRanges());
    }

    public Boolean getRenderMockTiles() {
        if (this.cachedRenderMockTiles == null) {
            this.cachedRenderMockTiles = this.getFromOptionalOrElse(this.safeParseBoolean(this.osmHeightColorSymbolizer.getRenderMockTiles()), DEFAULT_RENDER_MOCK_TILES);
        }
        return this.cachedRenderMockTiles;
    }

    public Integer getExpensiveBlur() {
        if (this.cachedExpensiveBlur == null) {
            this.cachedExpensiveBlur = this.getFromOptionalOrElse(this.safeParseInteger(this.osmHeightColorSymbolizer.getExpensiveBlur()), DEFAULT_EXPENSIVE_BLUR);
        }
        return this.cachedExpensiveBlur;
    }

    public String toString() {
        return "OsmHeightColorSymbolizerAccessor[" + this.osmHeightColorSymbolizer + "]";
    }
}

